//
// ViewController.swift
//

import UIKit


class ViewController: UIViewController {

  @IBOutlet weak var tapMeButton: UIButton!
  @IBOutlet weak var predictionLabel: UILabel!
  
  let predictions = [
    "Yes.",
    "Sure thing.",
    "But of course!",
    "I'd bet on it.",
    "AWWW YISSS!",
    "No.",
    "Nuh-uh.",
    "Absolutely not!",
    "I wouldn't bet on it.",
    "HELL NO.",
    "Maybe.",
    "Possibly...",
    "Ask again later.",
    "I can't be certain.",
    "Reply hazy. Try again later."
  ]
  
  override func viewDidLoad() {
    super.viewDidLoad()
    predictionLabel.text = ""
  }

  override func didReceiveMemoryWarning() {
    super.didReceiveMemoryWarning()
    // Dispose of any resources that can be recreated.
  }

  @IBAction func buttonClicked(sender: UIButton) {
    
    // When the "Tap me" button tapped,
    // we want to:
    // 1. Disable the button
    // 2. Display a random magic 8-ball answer
    // 3. Wait 3 seconds, and then:
    //    a) Enable the button
    //    b) Clear the displayed answer
    
    tapMeButton.enabled = false
    predictionLabel.text = randomAnswer()
    delay(3.0) {
      self.tapMeButton.enabled = true
      self.predictionLabel.text = ""
    }
  }
  
  func randomAnswer() -> String {
    return predictions[randomIntUpToButNotIncluding(predictions.count)]
  }
  
}


// MARK: Utility functions

func delay(delay: Double, closure: ()->()) {
  
  // A handy bit of code created by Matt Neuburg, author of a lot of books including
  // iOS Programming Fundamentals with Swift (O'Reilly 2015).
  // See his reply in Stack Overflow for details:
  // http://stackoverflow.com/questions/24034544/dispatch-after-gcd-in-swift/24318861#24318861
  //
  // The secret sauce is Grand Central Dispatch's (GCD) dispatch_after() function.
  // Ray Wenderlich has a good tutorial on GCD at:
  // http://www.raywenderlich.com/79149/grand-central-dispatch-tutorial-swift-part-1
  
  dispatch_after(
    dispatch_time(
      DISPATCH_TIME_NOW,
      Int64(delay * Double(NSEC_PER_SEC))
    ),
    dispatch_get_main_queue(),
    closure
  )
}

func randomIntUpToButNotIncluding(count: Int) -> Int {
  return Int(arc4random_uniform(UInt32(count)))
}
